﻿using System;
using System.CodeDom;
using System.CodeDom.Compiler;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Text;
using System.Windows.Forms;
using Microsoft.CSharp;
using System.Collections;
using Microsoft.VisualBasic;
using CodeSpark.Classes;


namespace CodeSpark.Classes
{
    class formGen
    {
        private string tableName;

        public string TableName
        {
            get { return tableName; }
            set { tableName = value; }
        }

        private string dbName;

        public string DbName
        {
          get { return dbName; }
          set { dbName = value; }
        }

        private List<Microsoft.SqlServer.Management.Smo.Column> columns;

        internal List<Microsoft.SqlServer.Management.Smo.Column> Columns
        {
            get { return columns; }
            set { columns = value; }
        }

        private string language;

        public string Language
        {
            get { return language; }
            set { language = value; }
        }

        public formGen(string DBName, string table, List<Microsoft.SqlServer.Management.Smo.Column> columnCollection)
        {

            tableName = table;
            columns = columnCollection;
            dbName = DBName;
        }

        public void generateForms(string fileName)
        {
            generateLayout(fileName);
            generateFormCode(fileName);

        }

        public void generateMaster(string filename)
        {
            string script;
            //Create header
            script = "<%@ Master Language='" + Language + "' AutoEventWireup='true' Inherits='" + dbName + ".Master_MasterPage' Codebehind='Masterpage.master.cs' %>\r\n";
            script += "<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>\r\n";
            script += "<html xmlns='http://www.w3.org/1999/xhtml'>\r\n<head runat='server'>\r\n";
            script += "<title>" + dbName + "</title>\r\n";
            script += "<link href='~/Styles/Site.css' rel='stylesheet' type='text/css' />\r\n";
            script += "<asp:ContentPlaceHolder ID='Head' runat='server'>\r\n";
            script += "</asp:ContentPlaceHolder>\r\n";
            script += "</head>\r\n<body>\r\n";
            script += "<form id='Form1' runat='server'>\r\n";
            script += "<asp:ContentPlaceHolder id='ContentPlaceHolder1' runat='server'>\r\n";
            script += "</asp:ContentPlaceHolder>\r\n";
            script += "</form>\r\n";
            script += "</body>\r\n";
            script += "</html>\r\n";

            StreamWriter sw = new StreamWriter(filename);
            sw.Write(script);
            sw.Flush();
            sw.Close();

        }

        public void generateMasterCode(string filename)
        {
            
            string script = string.Empty;
            script += "using System;";
            script += "using System.Collections.Generic;\r\n";
            script += "using System.Linq;\r\n";
            script += "using System.Web;\r\n";
            script += "using System.Web.UI;\r\n";
            script += "using System.Web.UI.WebControls;\r\n";

            script += "namespace " + dbName + "\r\n";
            script += "{\r\n";
            script += "    public partial class Master : System.Web.UI.MasterPage\r\n";
            script += "    {\r\n";
            script += "        protected void Page_Load(object sender, EventArgs e)\r\n";
            script += "        {\r\n";
            script += "       \r\n";
            script += "        }\r\n";
            script += "    }\r\n";
            script += "}\r\n";


            StreamWriter sw = new StreamWriter(filename + ".cs");
            sw.Write(script);
            sw.Flush();
            sw.Close();

            script = string.Empty;

            script += "namespace " + dbName + "\r\n";
            script += "{\r\n";
            script += "    public partial class Master\r\n";
            script += "    {\r\n";

            script += "        protected global::System.Web.UI.WebControls.ContentPlaceHolder HeadContent;\r\n";

            script += "        protected global::System.Web.UI.ScriptManager MasterPageScriptManager;\r\n";

            script += "        protected global::System.Web.UI.WebControls.LoginView HeadLoginView;\r\n";

            script += "        protected global::System.Web.UI.HtmlControls.HtmlAnchor HeadHomeLink;\r\n";

            script += "        protected global::System.Web.UI.HtmlControls.HtmlAnchor HeadAboutLink;\r\n";

            script += "        protected global::System.Web.UI.WebControls.ContentPlaceHolder MainContent;\r\n";
            script += "    }\r\n";
            script += "}\r\n";



            sw = new StreamWriter(filename + "designer.cs");
            sw.Write(script);
            sw.Flush();
            sw.Close();
        }

        protected void generateLayout(string fileName)
        {
            string script;
            //Create header
            script = "<%@ Page Language='" + Language + "' MasterPageFile='~/Master/Masterpage.master' AutoEventWireup='true' Inherits='";
            script += dbName + "." + tableName + "' Title='" + tableName + "' Codebehind='" + tableName + ".aspx.cs' %>\r\n";
            script += "<asp:Content ID='Content1' ContentPlaceHolderID='head' runat='server'>\r\n";
            script += "</asp:Content>\r\n";
            script += "<asp:Content ID='Content2' ContentPlaceHolderID='ContentPlaceHolder1' runat='server'>\r\n";
            script += "<table cellpadding='2' border='0'>\r\n<tr>";

            foreach (Microsoft.SqlServer.Management.Smo.Column col in columns)
            {
                
                string colName3 = col.Name;
                string columnType = col.DataType.Name;
                int maxlength = col.DataType.MaximumLength;
                if(col.InPrimaryKey == false)
                {

                script += "<td>";
                script += clsStrings.ToUpperFirstChar(colName3) + ":</td>";
                script += "<td style='width:50px'><span style='color:white;'>*</span></td><td  style='width:100px'>";


         
                switch (columnType.ToLower())
                {
                    case "tinyint" :
                        script += "<asp:TextBox ID='txt" + colName3 + "' runat='server' MaxLength='3'  Width='80%'></asp:TextBox>\r\n</td><td>";
                        script += "<asp:RangeValidator ID='rv" + colName3 + "' runat='server' ControlToValidate='txt" + colName3 + "' ErrorMessage='Not Valid' MaximumValue='255' MinimumValue='0' SetFocusOnError='True' Type='Integer'></asp:RangeValidator>\r\n";
                        break;
                    case "smallint":
                        script += "<asp:TextBox ID='txt" + colName3 + "' runat='server' MaxLength='5'  Width='80%'></asp:TextBox>\r\n</td><td>";
                        script += "<asp:RangeValidator ID='rv" + colName3 + "' runat='server' ControlToValidate='txt" + colName3 + "' ErrorMessage='Not Valid' MaximumValue='32767' MinimumValue='-32767' SetFocusOnError='True' Type='Integer'></asp:RangeValidator>\r\n";
                        break;
                    case "int":
                        script += "<asp:TextBox ID='txt" + colName3 + "' runat='server' MaxLength='12'  Width='80%'></asp:TextBox>\r\n</td><td>";
                        script += "<asp:RangeValidator ID='rv" + colName3 + "' runat='server' ControlToValidate='txt" + colName3 + "' ErrorMessage='Not Valid' MaximumValue='2147483647' MinimumValue='-2147483647' SetFocusOnError='True' Type='Integer'></asp:RangeValidator>\r\n";
                        break;
                    case "bigint":
                        script += "<asp:TextBox ID='txt" + colName3 + "' runat='server' MaxLength='20'  Width='80%'></asp:TextBox>\r\n</td><td>";
                        script += "<asp:RangeValidator ID='rv" + colName3 + "' runat='server' ControlToValidate='txt" + colName3 + "' ErrorMessage='Not Valid' MaximumValue='9223372036854775808' MinimumValue='-9223372036854775808' SetFocusOnError='True' Type='Integer'></asp:RangeValidator>\r\n";
                        break;
                    case "money":
                        script += "<asp:TextBox ID='txt" + colName3 + "' runat='server' MaxLength='20'  Width='80%'></asp:TextBox>\r\n</td><td>";
                        script += "<asp:RangeValidator ID='rv" + colName3 + "' runat='server' ControlToValidate='txt" + colName3 + "' ErrorMessage='Not Valid' MaximumValue='922337203685477.5807' MinimumValue='-922337203685477.5807' SetFocusOnError='True' Type='Currency'></asp:RangeValidator>\r\n";
                        break;
                    case "float":
                        script += "<asp:TextBox ID='txt" + colName3 + "' runat='server' MaxLength='20'  Width='80%'></asp:TextBox>\r\n</td><td>";
                        script += "<asp:RangeValidator ID='rv" + colName3 + "' runat='server' ControlToValidate='txt" + colName3 + "' ErrorMessage='Not Valid' MaximumValue='1000000' MinimumValue='0' SetFocusOnError='True' Type='Double'></asp:RangeValidator>\r\n";
                        break;

                    case "char":
                    case "nchar":
                    case "varchar":
                    case "nvarchar":
                        script += "<asp:TextBox ID='txt" + colName3 + "' runat='server' MaxLength='" + maxlength.ToString() + "'  Width='80%'></asp:TextBox>\r\n";
                        script += "</td><td><asp:RequiredFieldValidator ID='Rfv" + colName3 + "' ControlToValidate='txt" + colName3 + "' ErrorMessage='" + colName3 + " is required.' Display='Dynamic' runat='server' />\r\n";
                        break;

                    case "text":
                    case "ntext":
                    case "xml":
                        script += "<asp:TextBox ID='txt" + colName3 + "' runat='server' MaxLength='" + maxlength.ToString() + "'  Width='80%' TextMode='MultiLine'></asp:TextBox>\r\n";
                        script += "</td><td>";
                        break;

                    case "decimal": 
                    case "real":
                        script += "<asp:TextBox ID='txt" + colName3 + "' runat='server' MaxLength='" + maxlength.ToString() + "'  Width='80%'></asp:TextBox>\r\n</td><td>";
                        script += "<asp:RangeValidator ID='rv" + colName3 + "' runat='server' ControlToValidate='txt" + colName3 + "' ErrorMessage='Not Valid' MaximumValue='1000000000' MinimumValue='-1000000000' SetFocusOnError='True' Type='Double'></asp:RangeValidator>\r\n";
                        break;
 
                    case  "image":
                        script += "<asp:Image ID='img" + colName3 + "' runat='server' />";
                        script += "<asp:FileUpload ID=fileUp" + colName3 + " runat='server' />\r\n</td><td>";
                        break;
                    

                  
                    case "smalldatetime":
                    case "date":
                    case "datetime":
                    case "datetime2":
                        script += "<asp:Calendar ID='cal" + colName3 + "' runat='server'></asp:Calendar>\r\n";
                        script += "</td><td>";
                        break;

                    case "datetimeoffset":

                        script += "</td><td>";
                        break;
                    case "bit":
                        script += "<asp:CheckBox ID='ck" + colName3 + "' runat='server' RepeatDirection='Horizontal' />\r\n";
                        script += "</td><td>";
                        break;
                    
                    case "varbinary":
                    case "uniqueidentifier":

                    default:
                        script += "<asp:TextBox ID='txt" + colName3 + "' runat='server' MaxLength='" + maxlength.ToString() + "'  Width='80%'></asp:TextBox>\r\n";
                        script += "</td><td><asp:RequiredFieldValidator ID='Rfv" + colName3 + "' ControlToValidate='txt" + colName3 + "' ErrorMessage='" + colName3 + " is required.' Display='Dynamic' runat='server' />\r\n";
                        break;
                }

                }else
                {
                    script += "<td>";
                    script += clsStrings.ToUpperFirstChar(colName3) + ":</td>";
                    script += "<td></td>";
                    script +="<td><asp:Label ID='lbl" + colName3 + "' runat='server' /></td>";
                    script += "<td>";
                }
                
                script += "</td>\r\n</tr>\r\n<tr>";
            }

            script += "<td>&nbsp;</td><td><asp:Button ID='BtnUpdate' runat='server' Text='Save' onclick='BtnUpdate_Click' Width='64px' />";
            script += "<asp:Button ID='BtnCancel' runat='server' Text='Cancel' onclick='BtnCancel_Click' /></td></tr>";

            script += "</table>\r\n";
            script += "</asp:Content>\r\n";

            
            StreamWriter sw = new StreamWriter(fileName );
            sw.Write(script);
            sw.Flush();
            sw.Close();
            }


        protected void generateFormCode(string fileName)
        {

            tableName = clsStrings.ToUpperFirstChar(tableName);
            ArrayList keys = new ArrayList();

            foreach (Microsoft.SqlServer.Management.Smo.Column col in columns)
            {

                string colName = col.Name;
                string columnType = col.DataType.Name;
                

                int maxlength = col.DataType.MaximumLength;
                if (col.InPrimaryKey == true)
                {

                    keys.Add(colName);
                }
                
            }
            //string[] primkeys =(string[]) keys.ToArray();
            string[] primkeys = keys.ToArray(typeof(string)) as string[];
           
            CodeCompileUnit compileUnit = new CodeCompileUnit();
            CodeNamespace ns = new CodeNamespace(dbName);
            ns.Imports.Add(new CodeNamespaceImport("System"));
            ns.Imports.Add(new CodeNamespaceImport("System.Text"));
            ns.Imports.Add(new CodeNamespaceImport("System.Data"));
            ns.Imports.Add(new CodeNamespaceImport("System.Data.SqlClient"));

            CodeTypeDeclaration ctd = new CodeTypeDeclaration(clsStrings.ToLowerFirstChar(tableName));
            ctd.IsClass = true;
            ctd.IsPartial = true;
            ctd.BaseTypes.Add("System.Web.UI.Page"); 
            
            ns.Types.Add(ctd);
            compileUnit.Namespaces.Add(ns);

            System.CodeDom.CodeMemberMethod codeMethodPageLoad;
            System.CodeDom.CodeParameterDeclarationExpression codeParameterExpression;

            // Add Page_Load method

            codeMethodPageLoad = new System.CodeDom.CodeMemberMethod();
            codeMethodPageLoad.Name = "Page_Load";
            codeMethodPageLoad.Attributes = MemberAttributes.Family | MemberAttributes.Final;
            // Add sender parameter

            codeParameterExpression = new
                System.CodeDom.CodeParameterDeclarationExpression(typeof(object), "sender");
            codeMethodPageLoad.Parameters.Add(codeParameterExpression);

            // Add eventargs parameter

            codeParameterExpression = new
                System.CodeDom.CodeParameterDeclarationExpression(
                                   typeof(System.EventArgs), "e");
            codeMethodPageLoad.Parameters.Add(codeParameterExpression);
            //add in call to retrieve details using key

            CodeExpressionStatement   loaddetails = new CodeExpressionStatement(
                 new CodeMethodInvokeExpression(
                      new CodeMethodReferenceExpression(
                         new CodeThisReferenceExpression(),
                             "load" + tableName,
                                 new CodeTypeReference[] {}),
                                           new CodeExpression[0]));
           

            CodeStatementCollection keycol = new CodeStatementCollection();
            ArrayList keystatements = new ArrayList();
            
            foreach (string keyitem in primkeys)
            {
                //declare variable to store request value for primary key - need to check primary key type in future version
                CodeVariableDeclarationStatement qryvariableDeclaration = new CodeVariableDeclarationStatement(typeof(int), tableName + keyitem);
                keystatements.Add(qryvariableDeclaration);
                CodeAssignStatement setkey = new CodeAssignStatement(new CodeVariableReferenceExpression(tableName + keyitem), new CodeSnippetExpression("Convert.ToInt32(Request.QueryString.Get(" + (char)34 + keyitem + (char)34 + "))"));
                keycol.Add(setkey);
                keystatements.Add(setkey);
            }
            
            
            CodeStatement[] keystatementsnocall = keystatements.ToArray(typeof(CodeStatement)) as CodeStatement[];
            keystatements.Add(loaddetails);
            
            CodeStatement[] statements = keystatements.ToArray(typeof(CodeStatement)) as CodeStatement[];

            CodeConditionStatement conditionalStatement = new CodeConditionStatement(
                // The condition to test.
                new CodeVariableReferenceExpression("IsPostBack"),
                // The statements to execute if the condition evaluates to true.
                new CodeStatement[] { new CodeCommentStatement("If condition is true, execute these statements.") },
                // The statements to execute if the condition evalues to false.
                statements);

            codeMethodPageLoad.Statements.Add(conditionalStatement);
            
            ctd.Members.Add(codeMethodPageLoad);

            //Add in method to load details
            System.CodeDom.CodeMemberMethod loaddetail = new System.CodeDom.CodeMemberMethod();
            loaddetail.Name = "load" + tableName;
            //cls + dbname => data
            // create new entity class
            // load data into it (identify primary key(s))
            // populate form with data from entity

            CodeVariableDeclarationStatement variableDeclaration = new CodeVariableDeclarationStatement(tableName,"my" + tableName );

            string callparams = "";
            ArrayList qrystatements = new ArrayList();
            foreach (string keyitem in primkeys)
            {
                //declare variable to store request value for primary key - need to check primary key type in future version
                CodeVariableDeclarationStatement qryvariableDeclaration2 = new CodeVariableDeclarationStatement(typeof(int), tableName + keyitem);
                qrystatements.Add(qryvariableDeclaration2);
                CodeAssignStatement setkey2 = new CodeAssignStatement(new CodeVariableReferenceExpression(tableName + keyitem), new CodeSnippetExpression("Convert.ToInt32(Request.QueryString.Get(" + (char)34 + keyitem + (char)34 + "))"));
                keycol.Add(setkey2);
                qrystatements.Add(setkey2);
                callparams += tableName + keyitem + ",";
            }
            CodeStatement[] qrystatementsnocall = qrystatements.ToArray(typeof(CodeStatement)) as CodeStatement[];
            
            loaddetail.Statements.AddRange(qrystatementsnocall);
            loaddetail.Statements.Add(variableDeclaration);
            if(callparams != string.Empty)
            callparams = callparams.Substring(0, callparams.Length -1);
            CodeAssignStatement as1 = new CodeAssignStatement(new CodeVariableReferenceExpression("my" + tableName), new CodeSnippetExpression("cls" +clsStrings.ToLowerFirstChar(tableName) + ".get" + tableName + "(" +
                callparams + ")"));


            loaddetail.Statements.Add(as1);
            
            
            foreach (Microsoft.SqlServer.Management.Smo.Column col in columns)
            {

                string colName = col.Name;
                string columnType = col.DataType.Name;
                int maxlength = col.DataType.MaximumLength;
                if (col.InPrimaryKey == true)
                {
                    //load into label
                    CodeAssignStatement as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("lbl" + colName + ".Text"), new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName) + ".ToString()"));
                    loaddetail.Statements.Add(as2);
                }
                else
                {
                    CodeAssignStatement as2 = new CodeAssignStatement();
                    CodeMethodInvokeExpression invokeToString = new CodeMethodInvokeExpression();

                    switch (columnType.ToLower())
                    {
                        case "tinyint":
                        case "smallint":
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("txt" + colName + ".Text"), new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName) + ".ToString()"));
                            break;
                        case "int":
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("txt" + colName + ".Text"), new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName) + ".ToString()"));
 
                            break;
                        case "bigint":
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("txt" + colName + ".Text"), new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName) + ".ToString()"));
                            
                            break;
                        case "money":
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("txt" + colName + ".Text"), new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName) + ".ToString()"));
                            break;
                        case "float":
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("txt" + colName + ".Text"), new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName) + ".ToString()"));
                            break;
                        case "char":
                        case "nchar":
                        case "varchar":
                        case "nvarchar":
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("txt" + colName + ".Text"), new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName) + ".ToString()"));
                            break;
                        case "text":
                        case "ntext":
                        case "xml":
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("txt" + colName + ".Text"), new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName) + ".ToString()"));
                            break;
                        case "decimal":
                        case "real":
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("txt" + colName + ".Text"), new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName) + ".ToString()"));
                            break;
                        case "image":
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("txt" + colName + ".Text"), new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName) + ".ToString()"));
                            break;
                        case "smalldatetime":
                        case "date":
                        case "datetime":
                        case "datetime2":
                        case "datetimeoffset":
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("cal" + colName + ".SelectedDate"), new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName)));
                            break;
                        case "bit":
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("ck" + colName + ".Checked"), new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName)));
                            break;
                        case "varbinary":
                        case "uniqueidentifier":
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("txt" + colName + ".Text"), new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName) + ".ToString()"));
                            break;
                        default:
                            break;
                    }
                    loaddetail.Statements.Add(as2);
                }
            }
            ctd.Members.Add(loaddetail);

            //protected void BtnUpdate_Click(object sender, EventArgs e)
            System.CodeDom.CodeMemberMethod BtnUpdateMethod = new System.CodeDom.CodeMemberMethod();
            BtnUpdateMethod.Name = "BtnUpdate_Click";
            BtnUpdateMethod.Attributes = MemberAttributes.Family | MemberAttributes.Final;
            // Add sender parameter

            codeParameterExpression = new System.CodeDom.CodeParameterDeclarationExpression(typeof(object), "sender");
            BtnUpdateMethod.Parameters.Add(codeParameterExpression);

            // Add eventargs parameter

            codeParameterExpression = new System.CodeDom.CodeParameterDeclarationExpression(typeof(System.EventArgs), "e");
            BtnUpdateMethod.Parameters.Add(codeParameterExpression);
            // add code to save details (assume its a new record for now)
            // create new instance of entity class
            // populate entity with values from form controls
            // uses control class to save entity
            BtnUpdateMethod.Statements.AddRange(qrystatementsnocall);

            CodeVariableDeclarationStatement entityDeclaration = new CodeVariableDeclarationStatement(clsStrings.ToUpperFirstChar(tableName), "my" + tableName);
            CodeObjectCreateExpression objectCreate1 = new CodeObjectCreateExpression(clsStrings.ToUpperFirstChar(tableName), new CodeExpression[] { });
            CodeAssignStatement as3 = new CodeAssignStatement(new CodeVariableReferenceExpression("my" + tableName), objectCreate1);

            BtnUpdateMethod.Statements.Add(entityDeclaration);
            BtnUpdateMethod.Statements.Add(as3);

            foreach (Microsoft.SqlServer.Management.Smo.Column col in columns)
            {
                string colName = col.Name;
                string columnType = col.DataType.Name;
                int maxlength = col.DataType.MaximumLength;
                if (col.InPrimaryKey == true)
                {
                    CodeAssignStatement as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar( colName)), new CodeVariableReferenceExpression(tableName + colName));
                    BtnUpdateMethod.Statements.Add(as2);
                }
                else
                {
                    CodeAssignStatement as2= new CodeAssignStatement();
                    CodeMethodInvokeExpression invokeToString =new CodeMethodInvokeExpression();

                    switch (columnType.ToLower())
                    {
                        case "tinyint":
                        case "smallint":
                            invokeToString = new CodeMethodInvokeExpression(new CodeTypeReferenceExpression(typeof(Convert)), "ToInt16", new CodeVariableReferenceExpression("txt" + colName + ".Text"));
                             as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName)), invokeToString);
                            break;
                        case "int":                     
                            invokeToString = new CodeMethodInvokeExpression(new CodeTypeReferenceExpression(typeof(Convert)), "ToInt32", new CodeVariableReferenceExpression("txt" + colName + ".Text"));
                             as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName)), invokeToString);
                            break;
                        case "bigint":
                            invokeToString = new CodeMethodInvokeExpression(new CodeTypeReferenceExpression(typeof(Convert)), "ToInt64", new CodeVariableReferenceExpression("txt" + colName + ".Text"));
                             as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName)), invokeToString);
                            break;
                        case "money":
                           invokeToString = new CodeMethodInvokeExpression(new CodeTypeReferenceExpression(typeof(Convert)), "ToDecimal", new CodeVariableReferenceExpression("txt" + colName + ".Text"));
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName)), invokeToString);
                             break;
                        case "float":
                           invokeToString = new CodeMethodInvokeExpression(new CodeTypeReferenceExpression(typeof(Convert)), "ToSingle", new CodeVariableReferenceExpression("txt" + colName + ".Text"));
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName)), invokeToString);
                             break;
                        case "char":
                        case "nchar":
                        case "varchar":
                        case "nvarchar":
                           invokeToString = new CodeMethodInvokeExpression(new CodeTypeReferenceExpression(typeof(Convert)), "ToString", new CodeVariableReferenceExpression("txt" + colName + ".Text"));
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName)), invokeToString);
                            break;
                        case "text":
                        case "ntext":
                        case "xml":
                           invokeToString = new CodeMethodInvokeExpression(new CodeTypeReferenceExpression(typeof(Convert)), "ToString", new CodeVariableReferenceExpression("txt" + colName + ".Text"));
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName)), invokeToString);
                             break;
                        case "decimal":
                             invokeToString = new CodeMethodInvokeExpression(new CodeTypeReferenceExpression(typeof(Convert)), "ToDecimal", new CodeVariableReferenceExpression("txt" + colName + ".Text"));
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName)), invokeToString);
                             break;
                        case "real":
                           invokeToString = new CodeMethodInvokeExpression(new CodeTypeReferenceExpression(typeof(Convert)), "ToDouble", new CodeVariableReferenceExpression("txt" + colName + ".Text"));
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName)), invokeToString);
                             break;
                        case "image":
                            invokeToString = new CodeMethodInvokeExpression(new CodeTypeReferenceExpression(typeof(Convert)), "ToBase64CharArray", new CodeVariableReferenceExpression("txt" + colName + ".Text"));
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName)), invokeToString);
                             break;
                        case "smalldatetime":
                        case "date":
                        case "datetime":
                        case "datetime2":
                        case "datetimeoffset":
                            invokeToString = new CodeMethodInvokeExpression(new CodeTypeReferenceExpression(typeof(Convert)), "ToDateTime", new CodeVariableReferenceExpression("cal" + colName + ".SelectedDate"));
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName)), invokeToString);
                            break;
                        case "bit":
                            invokeToString = new CodeMethodInvokeExpression(new CodeTypeReferenceExpression(typeof(Convert)), "ToBoolean", new CodeVariableReferenceExpression("ck" + colName + ".Checked"));
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName)), invokeToString);
                            break;
                        case "varbinary":
                        case "uniqueidentifier":
                            invokeToString = new CodeMethodInvokeExpression(new CodeTypeReferenceExpression(typeof(Convert)), "ToString", new CodeVariableReferenceExpression("txt" + colName + ".Text"));
                            as2 = new CodeAssignStatement(new CodeVariableReferenceExpression("my" + tableName + "." + clsStrings.ToUpperFirstChar(colName)), invokeToString);
                            break;
                        default:
                            break;
                    }
                    BtnUpdateMethod.Statements.Add(as2);
                }
            }

            CodeSnippetExpression savedata = new CodeSnippetExpression("cls" + clsStrings.ToLowerFirstChar(tableName) + ".Update(my" + tableName + ")");
            BtnUpdateMethod.Statements.Add(savedata);

            ctd.Members.Add(BtnUpdateMethod);

            CodeDomProvider provider;
            
            provider = new CSharpCodeProvider();
            
            if (this.Language == "C#")
            {
                provider = new CSharpCodeProvider();

                this.GenerateCode(provider, compileUnit, fileName);
            }
            else if (this.Language == "VB")
            {
                provider = new VBCodeProvider();

                this.GenerateCode(provider, compileUnit, fileName);
            }
        }

        public void generateGridLayout(string fileName)
        {
            string script;
            //Create header
            script = "<%@ Page Language='" + Language + "' MasterPageFile='~/Master/Masterpage.master' AutoEventWireup='true' Inherits='";
            script += dbName + "." + clsStrings.ToLowerFirstChar(tableName) + "Grid' Title='" + tableName + "' Codebehind='" + clsStrings.ToLowerFirstChar(tableName) + "Grid.cs' %>\r\n";
            script += "<asp:Content ID='Content1' ContentPlaceHolderID='head' runat='server'>\r\n";
            script += "</asp:Content>\r\n";
            script += "<asp:Content ID='Content2' ContentPlaceHolderID='ContentPlaceHolder1' runat='server'>\r\n";
            script += "<asp:GridView ID='GridView1' runat='server' AutoGenerateColumns='False' DataKeyNames='id' DataSourceID='SqlDataSource1' onselectedindexchanged='GridView1_SelectedIndexChanged'>";
            script += "<Columns>\r\n";
            string fields = string.Empty;
            foreach (Microsoft.SqlServer.Management.Smo.Column col in columns)
            {

                string colName = col.Name;
                string columnType = col.DataType.Name;
                int maxlength = col.DataType.MaximumLength;
                if (col.InPrimaryKey == true)
                {
                    script += "<asp:BoundField DataField=" + (char)34 + colName + (char)34 + " HeaderText=" + (char)34 + colName + (char)34 + " InsertVisible='False' ReadOnly='True' SortExpression=" + (char)34 + colName + (char)34 + " />\r\n";
                }else
                {
                    script += "<asp:BoundField DataField=" + (char)34 + colName + (char)34 + " HeaderText=" + (char)34 + colName + (char)34 + " InsertVisible='False' SortExpression=" + (char)34 + colName + (char)34 + " />\r\n";
                }
                fields += "[" + colName + "],";
            }
            fields = fields.Substring(0, fields.Length - 1);
            script += "</Columns>\r\n";
            script += "</asp:GridView>\r\n";
            script += "<asp:SqlDataSource ID='SqlDataSource1' runat='server' ";
            script += "ConnectionString='<%$ ConnectionStrings:" + dbName + "ConnectionString %>' ";
            script += "SelectCommand=" + (char)34 + "SELECT " + fields + " FROM " + tableName + (char)34 + "></asp:SqlDataSource>\r\n</asp:Content>";

            StreamWriter sw = new StreamWriter(fileName);
            sw.Write(script);
            sw.Flush();
            sw.Close();
        }


        public void generateGridFormCode(string fileName)
        {
            CodeDomProvider provider;

            tableName = clsStrings.ToUpperFirstChar(tableName);
            ArrayList keys = new ArrayList();

            foreach (Microsoft.SqlServer.Management.Smo.Column col in columns)
            {
                string colName = col.Name;
                string columnType = col.DataType.Name;
                int maxlength = col.DataType.MaximumLength;
                if (col.InPrimaryKey == true)
                {
                    keys.Add(colName);
                }
            }
            
            string[] primkeys = keys.ToArray(typeof(string)) as string[];

            CodeCompileUnit compileUnit = new CodeCompileUnit();
            CodeNamespace ns = new CodeNamespace(dbName);
            ns.Imports.Add(new CodeNamespaceImport("System"));
            ns.Imports.Add(new CodeNamespaceImport("System.Text"));
            ns.Imports.Add(new CodeNamespaceImport("System.Data"));
            ns.Imports.Add(new CodeNamespaceImport("System.Data.SqlClient"));

            CodeTypeDeclaration ctd = new CodeTypeDeclaration(clsStrings.ToLowerFirstChar(tableName + "Grid"));
            ctd.IsClass = true;
            ctd.IsPartial = true;
            ctd.BaseTypes.Add("System.Web.UI.Page");

            ns.Types.Add(ctd);
            compileUnit.Namespaces.Add(ns);

            System.CodeDom.CodeMemberMethod codeMethodPageLoad;
            System.CodeDom.CodeParameterDeclarationExpression codeParameterExpression;

            // Add Page_Load method
            codeMethodPageLoad = new System.CodeDom.CodeMemberMethod();
            codeMethodPageLoad.Name = "Page_Load";
            codeMethodPageLoad.Attributes = MemberAttributes.Family|MemberAttributes.Final;
            // Add sender parameter
            codeParameterExpression = new System.CodeDom.CodeParameterDeclarationExpression(typeof(object), "sender");
            codeMethodPageLoad.Parameters.Add(codeParameterExpression);

            // Add eventargs parameter
            codeParameterExpression = new System.CodeDom.CodeParameterDeclarationExpression(typeof(System.EventArgs), "e");
            codeMethodPageLoad.Parameters.Add(codeParameterExpression);
            ctd.Members.Add(codeMethodPageLoad);


            CodeMemberMethod codeMethodGridSelect;
            codeMethodGridSelect = new System.CodeDom.CodeMemberMethod();
            codeMethodGridSelect.Name = "GridView1_SelectedIndexChanged";
            codeMethodGridSelect.Attributes = MemberAttributes.Family | MemberAttributes.Final;
            // Add sender parameter
            codeParameterExpression = new System.CodeDom.CodeParameterDeclarationExpression(typeof(object), "sender");
            codeMethodGridSelect.Parameters.Add(codeParameterExpression);

            // Add eventargs parameter
            codeParameterExpression = new System.CodeDom.CodeParameterDeclarationExpression(typeof(System.EventArgs), "e");
            if (primkeys.Length > 0)
            {
                codeMethodGridSelect.Parameters.Add(codeParameterExpression);
                CodeVariableDeclarationStatement intid = new CodeVariableDeclarationStatement(typeof(int), primkeys[0]);

                var declaration = new CodeVariableDeclarationStatement()
                {
                    Name = primkeys[0],
                    Type = new CodeTypeReference(typeof(int)),
                    InitExpression = new CodeMethodInvokeExpression(
                        new CodeTypeReferenceExpression(typeof(Convert)),
                        "ToInt32",
                        new CodeMethodReferenceExpression(new CodeVariableReferenceExpression("GridView1"),"SelectedValue",new CodeTypeReference[]{}))
                };
                codeMethodGridSelect.Statements.Add(declaration);
                //CodeMethodInvokeExpression redirectExpression = new CodeMethodInvokeExpression(new CodeMethodReferenceExpression(("Response"), "Redirect"), "TicketFormEdit.aspx?repID=" + (char)34 + " + id.ToString()",);
                
                if (this.Language == "C#")
                {
                    CodeSnippetStatement redirectExpression = new CodeSnippetStatement("Response.Redirect(" + (char)34 + tableName + ".aspx?" + primkeys[0] + "=" + (char)34 + " + " + primkeys[0] + ".ToString(), false);");
                    codeMethodGridSelect.Statements.Add(redirectExpression);
                }
                else
                {
                    CodeSnippetStatement redirectExpression = new CodeSnippetStatement("Response.Redirect(" + (char)34 + tableName + ".aspx?" + primkeys[0] + "=" + (char)34 + " + " + primkeys[0] + ".ToString(), false)");
                    codeMethodGridSelect.Statements.Add(redirectExpression);
                }
            }

            ctd.Members.Add(codeMethodGridSelect);

            // finally, generate our code to specified codeProvider
            if (this.Language == "C#")
            {
                provider = new CSharpCodeProvider();
                this.GenerateCode(provider, compileUnit, fileName);
            }
            else if (this.Language == "VB")
            {
                provider = new VBCodeProvider();
                this.GenerateCode(provider, compileUnit, fileName);
            }
        }



        public void GenerateControlClass(string NameSpace, string Class,string filename)
        {
            CodeDomProvider provider;

            provider = new CSharpCodeProvider();

            //this.PrintToLog(string.Format("Generating some initialized code and methods ..."));
            System.Windows.Forms.Application.DoEvents();
            CodeCompileUnit compileUnit = new CodeCompileUnit();
            CodeNamespace ns = new CodeNamespace(NameSpace);
            ns.Imports.Add(new CodeNamespaceImport("System"));
            ns.Imports.Add(new CodeNamespaceImport("System.Text"));
            ns.Imports.Add(new CodeNamespaceImport("System.Data"));
            ns.Imports.Add(new CodeNamespaceImport("System.Data.SqlClient"));
            ns.Imports.Add(new CodeNamespaceImport("System.Configuration"));
            ns.Imports.Add(new CodeNamespaceImport("System.Linq"));
            // create our class
            CodeTypeDeclaration ctd = new CodeTypeDeclaration("cls" + clsStrings.ToLowerFirstChar(Class));
            ctd.IsClass = true;
            ns.Types.Add(ctd);
            compileUnit.Namespaces.Add(ns);


            System.CodeDom.CodeMemberMethod UpdateMethod = new System.CodeDom.CodeMemberMethod();
            UpdateMethod.Name = "Update";
            UpdateMethod.Attributes = MemberAttributes.Public|MemberAttributes.Static;
            

            UpdateMethod.Parameters.Add(new CodeParameterDeclarationExpression(clsStrings.ToUpperFirstChar(Class),clsStrings.ToLowerFirstChar( Class)));

            CodeVariableDeclarationStatement connstr = new CodeVariableDeclarationStatement("SqlConnection", "conn");
            CodeAssignStatement conncon = new CodeAssignStatement(new CodeVariableReferenceExpression("conn"), new CodeObjectCreateExpression(typeof(System.Data.SqlClient.SqlConnection), new CodeExpression[] {new CodeSnippetExpression("ConfigurationManager.ConnectionStrings[0].ConnectionString") }));
            UpdateMethod.Statements.Add(connstr);
            UpdateMethod.Statements.Add(conncon);
            
            ArrayList keys = new ArrayList();
            string tempstr = "1=1";
            foreach (Microsoft.SqlServer.Management.Smo.Column col in columns)
            {

                string colName = col.Name;
                string columnType = col.DataType.Name;
                

                int maxlength = col.DataType.MaximumLength;
                if (col.InPrimaryKey == true)
                {

                    keys.Add(colName);
                    if(keys.Count ==1 )
                    {
                        tempstr += " and " + colName + " = " + (char)34 + " + " + clsStrings.ToLowerFirstChar(Class) + "." + clsStrings.ToUpperFirstChar(colName) + " + " + (char)34;

                    }
                    else
                    {
                        tempstr += " and " + colName + " = " + (char)34 + " + " + clsStrings.ToLowerFirstChar(Class) + "." + clsStrings.ToUpperFirstChar(colName) + " + " + (char)34;
                    }
                }
                
            }
            tempstr = tempstr.Replace("1=1 and", "");
            string selstr;
            selstr = "select * from " + tableName + " where " + tempstr;
            CodeVariableDeclarationStatement adaptstr = new CodeVariableDeclarationStatement("SqlDataAdapter", "adapt");
            CodeAssignStatement adaptcon = new CodeAssignStatement(new CodeVariableReferenceExpression("adapt"), new CodeObjectCreateExpression(typeof(System.Data.SqlClient.SqlDataAdapter), new CodeExpression[] { new CodeSnippetExpression((char)34 + selstr + (char)34), new CodeVariableReferenceExpression("conn") }));
            UpdateMethod.Statements.Add(adaptstr);
            UpdateMethod.Statements.Add(adaptcon);

            CodeMethodInvokeExpression open = new CodeMethodInvokeExpression(new CodeVariableReferenceExpression("conn"), "Open", new CodeExpression[] { });
            UpdateMethod.Statements.Add(open);
            // Define the table  
            CodeVariableDeclarationStatement stmtDeclTable = new CodeVariableDeclarationStatement(typeof(DataTable), "tb" + tableName);
            UpdateMethod.Statements.Add(stmtDeclTable); 
 
            // Create the table instance  
            CodeVariableReferenceExpression varTable = new CodeVariableReferenceExpression("tb" + tableName)  ;
            CodeObjectCreateExpression exprInitTable = new CodeObjectCreateExpression(typeof(DataTable), new CodePrimitiveExpression(tableName))  ;
            CodeAssignStatement stmtAsnTable = new CodeAssignStatement(varTable, exprInitTable)  ;
            UpdateMethod.Statements.Add(stmtAsnTable);
            CodeExpressionStatement filltable =new CodeExpressionStatement( new CodeMethodInvokeExpression(new CodeVariableReferenceExpression("adapt"), "Fill", new CodeExpression[] { new CodeVariableReferenceExpression("tb" + tableName) }));
            UpdateMethod.Statements.Add(filltable);


            //add update statements to 'update'
            ArrayList updatelist = new ArrayList();
            CodeCommentStatement editstat = new CodeCommentStatement("Edit methods");
            updatelist.Add(editstat);
            
            // Create the row instance  
            CodeVariableDeclarationStatement createrowupdate = new CodeVariableDeclarationStatement(typeof(DataRow), "row" + tableName);
            CodeAssignStatement  rowarray =new CodeAssignStatement(new CodeVariableReferenceExpression("row" + tableName),new CodeArrayIndexerExpression(new CodeVariableReferenceExpression("tb" + tableName + ".Rows"), new CodePrimitiveExpression(0)));
            updatelist.Add(createrowupdate);
            updatelist.Add(rowarray);

            //Assign Row Fields
            foreach (Microsoft.SqlServer.Management.Smo.Column col in columns)
            {
                string colName = col.Name;
                string columnType = col.DataType.Name;
                int maxlength = col.DataType.MaximumLength;
                if (col.InPrimaryKey != true)
                {
                    //row["emailname"] = emp.EmailName;
                    CodeAssignStatement rowass = new CodeAssignStatement(new CodeArrayIndexerExpression(new CodeVariableReferenceExpression("row" + tableName), new CodePrimitiveExpression(colName)),new CodeVariableReferenceExpression(clsStrings.ToLowerFirstChar( tableName) + "." + clsStrings.ToUpperFirstChar( colName)));
                    updatelist.Add(rowass);
                }
            }

            CodeExpressionStatement filltableupdate = new CodeExpressionStatement(new CodeMethodInvokeExpression(new CodeVariableReferenceExpression("adapt"), "Update", new CodeExpression[] { new CodeVariableReferenceExpression("tb" + tableName) }));
            updatelist.Add(filltableupdate);
           //Create the statements for the false condition
            // Create the row instance  
            CodeVariableReferenceExpression varRowfalse = new CodeVariableReferenceExpression("row" + tableName);
            
            ArrayList createlist = new ArrayList();
            //DataRow row;
            //row = empset.NewRow();
            CodeVariableDeclarationStatement createrow = new CodeVariableDeclarationStatement(typeof(DataRow), "row" + tableName);
            createlist.Add(createrow);
            //CodeExpressionStatement invrow =new CodeExpressionStatement( new CodeMethodInvokeExpression(new CodeVariableReferenceExpression("tb" + tableName), "NewRow", new CodeExpression[] { }));
            //createlist.Add(invrow);
            CodeAssignStatement assrow = new CodeAssignStatement(new CodeVariableReferenceExpression("row" + tableName),new CodeMethodInvokeExpression(new CodeVariableReferenceExpression("tb" + tableName), "NewRow", new CodeExpression[] { }) );
            createlist.Add(assrow);
            //Assign Row Fields
            foreach (Microsoft.SqlServer.Management.Smo.Column col in columns)
            {
                string colName = col.Name;
                CodeAssignStatement rowass = new CodeAssignStatement(new CodeArrayIndexerExpression(new CodeVariableReferenceExpression("row" + tableName), new CodePrimitiveExpression(colName)), new CodeVariableReferenceExpression(clsStrings.ToLowerFirstChar(tableName) + "." + clsStrings.ToUpperFirstChar(colName)));
                createlist.Add(rowass);
            }

            //tbemployee.Rows.Add(row); 
            CodeExpressionStatement invadd =new CodeExpressionStatement(new CodeMethodInvokeExpression(new CodeVariableReferenceExpression("tb" + tableName), "Rows.Add", new CodeExpression[] { new CodeVariableReferenceExpression("row" + tableName) }));
            createlist.Add(invadd);
            
            filltableupdate = new CodeExpressionStatement(new CodeMethodInvokeExpression(new CodeVariableReferenceExpression("adapt"), "Update", new CodeExpression[] { new CodeVariableReferenceExpression("tb" + tableName) }));
            createlist.Add(filltableupdate);

            CodeStatement[] update = updatelist.ToArray(typeof(CodeStatement)) as CodeStatement[];
            CodeStatement[] create = createlist.ToArray(typeof(CodeStatement)) as CodeStatement[];
            CodeConditionStatement ifnew = new CodeConditionStatement(new CodeSnippetExpression("tb" + tableName + ".Rows.Count > 0"), update, create);
            UpdateMethod.Statements.Add(ifnew);

            ctd.Members.Add(UpdateMethod);

            //Create Get entity method
            System.CodeDom.CodeMemberMethod getEntityMethod = new System.CodeDom.CodeMemberMethod();
            getEntityMethod.ReturnType = new CodeTypeReference(tableName);
            getEntityMethod.Attributes = MemberAttributes.Public | MemberAttributes.Static;
            

            getEntityMethod.Name = "get" + tableName;

            foreach (Microsoft.SqlServer.Management.Smo.Column col in columns)
            {
                string colName = col.Name;
                if (col.InPrimaryKey == true)
                {
                    getEntityMethod.Parameters.Add(new CodeParameterDeclarationExpression("Int32", colName));
                }
            }

            connstr = new CodeVariableDeclarationStatement("SqlConnection", "conn");
            conncon = new CodeAssignStatement(new CodeVariableReferenceExpression("conn"), new CodeObjectCreateExpression(typeof(System.Data.SqlClient.SqlConnection), new CodeExpression[] { new CodeSnippetExpression("ConfigurationManager.ConnectionStrings[0].ConnectionString") }));
            getEntityMethod.Statements.Add(connstr);
            getEntityMethod.Statements.Add(conncon);
            
            string tempstr2 = "1=1";
            
            foreach (Microsoft.SqlServer.Management.Smo.Column col in columns)
            {
                string colName = col.Name;
                if (col.InPrimaryKey == true)
                {
                    if (keys.Count == 1)
                    {
                        tempstr2 += " and " + colName + " = " + (char)34 + " + " + colName + " + " + (char)34 ;

                    }
                    else
                    {
                        tempstr2 += " and " + colName + " = " + (char)34 + " + " + colName + " + " + (char)34 ;
                    }
                }
            }

            tempstr2 = tempstr2.Replace("1=1 and", "");

            string selstr2;
            selstr2 = "select * from " + tableName + " where " + tempstr2;

            adaptstr = new CodeVariableDeclarationStatement("SqlDataAdapter", "adapt");
            adaptcon = new CodeAssignStatement(new CodeVariableReferenceExpression("adapt"), new CodeObjectCreateExpression(typeof(System.Data.SqlClient.SqlDataAdapter), new CodeExpression[] { new CodeSnippetExpression((char)34 + selstr2 + (char)34), new CodeVariableReferenceExpression("conn") }));
            getEntityMethod.Statements.Add(adaptstr);
            getEntityMethod.Statements.Add(adaptcon);

            open = new CodeMethodInvokeExpression(new CodeVariableReferenceExpression("conn"), "Open", new CodeExpression[] { });
            getEntityMethod.Statements.Add(open);
            // Define the table  
            stmtDeclTable = new CodeVariableDeclarationStatement(typeof(DataTable), "tb" + tableName);
            getEntityMethod.Statements.Add(stmtDeclTable);

            // Create the table instance  
            varTable = new CodeVariableReferenceExpression("tb" + tableName);
            exprInitTable = new CodeObjectCreateExpression(typeof(DataTable), new CodePrimitiveExpression(tableName));
            stmtAsnTable = new CodeAssignStatement(varTable, exprInitTable);
            getEntityMethod.Statements.Add(stmtAsnTable);
            filltable = new CodeExpressionStatement(new CodeMethodInvokeExpression(new CodeVariableReferenceExpression("adapt"), "Fill", new CodeExpression[] { new CodeVariableReferenceExpression("tb" + tableName) }));
            getEntityMethod.Statements.Add(filltable);
            //create new class entity
            CodeVariableDeclarationStatement classdec = new CodeVariableDeclarationStatement(tableName, tableName);
            CodeAssignStatement classinst =new CodeAssignStatement(new CodeVariableReferenceExpression(tableName), new CodeObjectCreateExpression(tableName, new CodeExpression[] { }));
            getEntityMethod.Statements.Add(classdec);
            getEntityMethod.Statements.Add(classinst);


            ArrayList retlist = new ArrayList();
            // Create the row instance  
            createrowupdate = new CodeVariableDeclarationStatement(typeof(DataRow), "row" + tableName);
            rowarray = new CodeAssignStatement(new CodeVariableReferenceExpression("row" + tableName), new CodeArrayIndexerExpression(new CodeVariableReferenceExpression("tb" + tableName + ".Rows"), new CodePrimitiveExpression(0)));
            retlist.Add(createrowupdate);
            retlist.Add(rowarray);

            //Assign Row Fields
            foreach (Microsoft.SqlServer.Management.Smo.Column col in columns)
            {
                string colName = col.Name;
                string columnType = col.DataType.Name;
                string typestr = string.Empty;

                int maxlength = col.DataType.MaximumLength;
                if (col.InPrimaryKey != true)
                {
                   switch (columnType.ToLower())
                    {
                        case "tinyint":
                        case "smallint":                    
                            typestr = "ToInt16";
                            break;
                        case "int":
                            typestr = "ToInt32";
                            break;
                        case "bigint":
                            typestr = "ToInt64";
                            break;
                        case "money":
                            typestr = "ToInt16";
                            break;
                        case "float":
                            typestr = "ToDouble";
                            break;                           
                        case "char":
                        case "nchar":
                        case "varchar":
                        case "nvarchar":
                            typestr = "ToString";
                            break;
                        case "text":
                        case "ntext":
                        case "xml":
                            typestr = "ToString";
                            break;
                        case "decimal":
                        case "real":
                            typestr = "ToDecimal";
                            break;
                        case "image":
                            typestr = "ToBase64CharArray";                         
                            break;
                        case "smalldatetime":
                        case "date":
                        case "datetime":
                        case "datetime2":                         
                            typestr = "ToDateTime";
                            break;
                        case "datetimeoffset":
                            typestr = "ToDateTime";
                            break;
                        case "bit":
                            typestr = "ToBoolean";
                            break;
                        case "varbinary":
                        case "uniqueidentifier":
                            typestr = "ToString";
                            break;
                        default:
                            break;
                    }

                    CodeArrayIndexerExpression exprArrIndexer = new CodeArrayIndexerExpression(new CodeVariableReferenceExpression("row" + tableName), new CodePrimitiveExpression(colName));
                    // ...Convert.ToString(...)
                    CodeMethodInvokeExpression invokeToString = new CodeMethodInvokeExpression(new CodeTypeReferenceExpression(typeof(Convert)), typestr, exprArrIndexer);
                    CodeAssignStatement rowass = new CodeAssignStatement(new CodeVariableReferenceExpression(tableName + "." + clsStrings.ToUpperFirstChar(colName)), invokeToString);
                    retlist.Add(rowass);

                }
            }
            CodeMethodReturnStatement retentity = new CodeMethodReturnStatement(new CodeArgumentReferenceExpression(tableName));
            retlist.Add(retentity);

            ArrayList nolist = new ArrayList();
            CodeMethodReturnStatement retnull = new CodeMethodReturnStatement(new CodePrimitiveExpression(null));
            nolist.Add(retnull);

            CodeStatement[] retrieve = retlist.ToArray(typeof(CodeStatement)) as CodeStatement[];
            CodeStatement[] nodata = nolist.ToArray(typeof(CodeStatement)) as CodeStatement[];
            CodeConditionStatement ifexists = new CodeConditionStatement(new CodeSnippetExpression("tb" + tableName + ".Rows.Count > 0"), retrieve, nodata);
            getEntityMethod.Statements.Add(ifexists);

            ctd.Members.Add(getEntityMethod);
            // finally, generate our code to specified codeProvider
            if (this.Language == "C#")
            {
                provider = new CSharpCodeProvider();

                this.GenerateCode(provider, compileUnit, filename);
            }
            else if (this.Language == "VB")
            {
                provider = new VBCodeProvider();

                this.GenerateCode(provider, compileUnit, filename);
            }

            //this.PrintToLog(string.Format("Code generation successfully completed for {0} Stored Procedure(s) in Database : {1}", dtHelper.Rows.Count, NameSpace));
        }

        public void GenerateDesignerClass(string NameSpace, string Class, string filename)
        {
            CodeDomProvider provider;

            provider = new CSharpCodeProvider();

            //this.PrintToLog(string.Format("Generating some initialized code and methods ..."));
            System.Windows.Forms.Application.DoEvents();
            CodeCompileUnit compileUnit = new CodeCompileUnit();
            CodeNamespace ns = new CodeNamespace(NameSpace);

            // create our class
            CodeTypeDeclaration ctd = new CodeTypeDeclaration(clsStrings.ToLowerFirstChar(Class));
            ctd.IsClass = true;
            ctd.IsPartial = true;
            ctd.Attributes = MemberAttributes.Public;
            ctd.TypeAttributes = System.Reflection.TypeAttributes.Public;

            ns.Types.Add(ctd);
            compileUnit.Namespaces.Add(ns);


            CodeMemberField field =field = new CodeMemberField();
            foreach (Microsoft.SqlServer.Management.Smo.Column col in columns)
            {
                string colName = col.Name;
                string columnType = col.DataType.Name;
                if (col.InPrimaryKey == true)
                {
                    if (this.Language == "C#")
                    {
                        field = new CodeMemberField("global::System.Web.UI.WebControls.Label", "lbl" + colName);
                    }else
                    {
                        field = new CodeMemberField("global.System.Web.UI.WebControls.Label", "lbl" + colName);
                    }
                }
                else
                {
                    if (this.Language == "C#")
                    {
                        
                        switch (columnType.ToLower())
                        {
                            case "tinyint":
                            case "smallint":
                                field = new CodeMemberField("global::System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            case "int":
                                field = new CodeMemberField("global::System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            case "bigint":
                                field = new CodeMemberField("global::System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            case "money":
                                field = new CodeMemberField("global::System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            case "float":
                                field = new CodeMemberField("global::System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            case "char":
                            case "nchar":
                            case "varchar":
                            case "nvarchar":
                                field = new CodeMemberField("global::System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            case "text":
                            case "ntext":
                            case "xml":
                                field = new CodeMemberField("global::System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            case "decimal":
                            case "real":
                                field = new CodeMemberField("global::System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            case "image":
                                field = new CodeMemberField("global::System.Web.UI.WebControls.Image", "img" + colName);       
                                break;
                            case "smalldatetime":
                            case "date":
                            case "datetime":
                            case "datetime2":
                                field = new CodeMemberField("global::System.Web.UI.WebControls.Calendar", "cal" + colName);
                                break;
                            case "datetimeoffset":
                                field = new CodeMemberField("global::System.Web.UI.WebControls.Calendar", "cal" + colName);
                                break;
                            case "bit":
                                field = new CodeMemberField("global::System.Web.UI.WebControls.CheckBox", "ck" + colName);
                                break;
                            case "varbinary":
                            case "uniqueidentifier":
                                field = new CodeMemberField("global::System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            default:
                                break;
                        }
                    }else
                    {
                        
                        switch (columnType.ToLower())
                        {
                            case "tinyint":
                            case "smallint":
                                field = new CodeMemberField("global.System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            case "int":
                                field = new CodeMemberField("global.System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            case "bigint":
                                field = new CodeMemberField("global.System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            case "money":
                                field = new CodeMemberField("global.System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            case "float":
                                field = new CodeMemberField("global.System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            case "char":
                            case "nchar":
                            case "varchar":
                            case "nvarchar":
                                field = new CodeMemberField("global.System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            case "text":
                            case "ntext":
                            case "xml":
                                field = new CodeMemberField("global.System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            case "decimal":
                            case "real":
                                field = new CodeMemberField("global.System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            case "image":
                                field = new CodeMemberField("global.System.Web.UI.WebControls.Image", "img" + colName);
                                break;
                            case "smalldatetime":
                            case "date":
                            case "datetime":
                            case "datetime2":
                                field = new CodeMemberField("global.System.Web.UI.WebControls.Calendar", "cal" + colName);
                                break;
                            case "datetimeoffset":
                                field = new CodeMemberField("global.System.Web.UI.WebControls.Calendar", "cal" + colName);
                                break;
                            case "bit":
                                field = new CodeMemberField("global.System.Web.UI.WebControls.CheckBox", "ck" + colName);
                                break;
                            case "varbinary":
                            case "uniqueidentifier":
                                field = new CodeMemberField("global.System.Web.UI.WebControls.TextBox", "txt" + colName);
                                break;
                            default:
                                break;
                        }
                    }
                }
                field.Attributes =  MemberAttributes.Family;
                ctd.Members.Add(field);
            }

            if (this.Language == "C#")
            {
                provider = new CSharpCodeProvider();

                this.GenerateCode(provider, compileUnit, filename);
            }
            else if (this.Language == "VB")
            {
                provider = new VBCodeProvider();

                this.GenerateCode(provider, compileUnit, filename);
            }
        }

        public void GenerateGridDesignerClass(string NameSpace, string Class, string filename)
        {
            CodeDomProvider provider;

            provider = new CSharpCodeProvider();

            //this.PrintToLog(string.Format("Generating some initialized code and methods ..."));
            System.Windows.Forms.Application.DoEvents();
            CodeCompileUnit compileUnit = new CodeCompileUnit();
            CodeNamespace ns = new CodeNamespace(NameSpace);

            // create our class
            CodeTypeDeclaration ctd = new CodeTypeDeclaration(clsStrings.ToLowerFirstChar(Class + "Grid"));
            ctd.IsClass = true;
            ctd.IsPartial = true;
            ctd.Attributes = MemberAttributes.Assembly;
            

            ns.Types.Add(ctd);
            compileUnit.Namespaces.Add(ns);


            CodeMemberField field1;
            CodeMemberField field2;

            //protected global::System.Web.UI.WebControls.GridView GridView1;
        
            //protected global::System.Web.UI.WebControls.SqlDataSource SqlDataSource1;
            if (this.Language == "C#")
            {
                field1 = new CodeMemberField("global::System.Web.UI.WebControls.GridView", "GridView1");
                field1.Attributes =  MemberAttributes.Family;
                ctd.Members.Add(field1);

                field2 = new CodeMemberField("global::System.Web.UI.WebControls.SqlDataSource", "SqlDataSource1");
                field2.Attributes = MemberAttributes.Family;
                ctd.Members.Add(field2);
            }
            else
            {
                field1 = new CodeMemberField("Global.System.Web.UI.WebControls.GridView", "GridView1");
                field1.Attributes = MemberAttributes.Family;
                ctd.Members.Add(field1);

                field2 = new CodeMemberField("Global.System.Web.UI.WebControls.SqlDataSource", "SqlDataSource1");
                field2.Attributes = MemberAttributes.Family;
                ctd.Members.Add(field2);
            
            }
            if (this.Language == "C#")
            {
                provider = new CSharpCodeProvider();

                this.GenerateCode(provider, compileUnit, filename);
            }
            else if (this.Language == "VB")
            {
                provider = new VBCodeProvider();

                this.GenerateCode(provider, compileUnit, filename);
            }
        }

        public void GenerateCode(CodeDomProvider provider, CodeCompileUnit compileUnit, string fileName)
        {
            // Build the source file name with the appropriate
            // language extension.
            String sourceFile;
            if (provider.FileExtension[0] == '.')
            {
                sourceFile = fileName + provider.FileExtension;
            }
            else
            {
                sourceFile = fileName + "." + provider.FileExtension;
            }

            // Create an IndentedTextWriter, constructed with
            // a StreamWriter to the source file.

            IndentedTextWriter tw = new IndentedTextWriter(new StreamWriter(sourceFile, false), "    ");
            CodeGeneratorOptions go = new CodeGeneratorOptions();
            
            // Generate source code using the code generator.
            provider.GenerateCodeFromCompileUnit(compileUnit, tw, new CodeGeneratorOptions());

            // Close the output file.
            tw.Close();
        }



    }
}
